#!/bin/bash
STAR --runMode genomeGenerate --runThreadN 10 \
     --genomeDir  /home/liyaru/public_Data/hg19_STAR \
     --genomeFastaFiles /home/liyaru/public_Data/hg19-ucsc/hg19.fa \
     --sjdbGTFfile /home/liyaru/public_Data/gene_gtf/gencode.v19.annotation.gtf \
     --sjdbOverhang 100
for ((i=45;i<=62;i++)) 
do 
trim_galore --fastqc --stringency 3 --paired /media/liyaru/LYR16T/BXM_human/GSE101571/SRR58373${i}_1.fastq.gz /media/liyaru/LYR16T/BXM_human/GSE101571/SRR58373${i}_2.fastq.gz -o /media/liyaru/LYR16T/BXM_human/Trim
STAR --genomeDir /home/liyaru/public_Data/hg19_STAR --runThreadN 6 --readFilesCommand gunzip -c --readFilesIn /media/liyaru/LYR16T/BXM_human/Trim/SRR58373${i}_1_val_1.fq.gz /media/liyaru/LYR16T/BXM_human/Trim/SRR58373${i}_2_val_2.fq.gz --outSAMtype BAM SortedByCoordinate --outFileNamePrefix /media/liyaru/LYR16T/BXM_human/result/SRR58373${i}
done

samtools merge ./merge/GV.bam SRR5837345Aligned.sortedByCoord.out.bam SRR5837346Aligned.sortedByCoord.out.bam

samtools merge ./merge/MII.bam SRR5837347Aligned.sortedByCoord.out.bam SRR5837348Aligned.sortedByCoord.out.bam

samtools merge ./merge/MII.bam SRR5837347Aligned.sortedByCoord.out.bam SRR5837348Aligned.sortedByCoord.out.bam

samtools merge ./merge/2cell.bam SRR5837349Aligned.sortedByCoord.out.bam SRR5837350Aligned.sortedByCoord.out.bam SRR5837351Aligned.sortedByCoord.out.bam SRR5837352Aligned.sortedByCoord.out.bam

samtools merge ./merge/4cell.bam SRR5837354Aligned.sortedByCoord.out.bam SRR5837355Aligned.sortedByCoord.out.bam SRR5837356Aligned.sortedByCoord.out.bam

samtools merge ./merge/8cell.bam SRR5837357Aligned.sortedByCoord.out.bam SRR5837358Aligned.sortedByCoord.out.bam

samtools merge ./merge/ICM.bam SRR5837359Aligned.sortedByCoord.out.bam SRR5837360Aligned.sortedByCoord.out.bam SRR5837361Aligned.sortedByCoord.out.bam SRR5837362Aligned.sortedByCoord.out.bam

samtools merge ./merge/hESC.bam SRR6940544Aligned.sortedByCoord.out.bam SRR6940545Aligned.sortedByCoord.out.bam

for i in GV MII 2cell 4cell 8cell ICM hESC
do 
samtools index ${i}.bam {i}.bai
bamCoverage -b ${i}.bam -o ${i}.bw
done
